package gov.va.med.mhv.common.api.util;

import java.util.LinkedHashMap;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.enumeration.ErrorEnum;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.transfer.ErrorTO;
import gov.va.med.mhv.common.essapi.cache.CacheHandler;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxrs.impl.ResponseBuilderImpl;

public class MHVEssApiUtility {

	private static final Log log = LogFactory.getLog(MHVEssApiUtility.class);
	public void checkUserStatus(UserProfileDTO userProfile) {
		
		if (userProfile == null) {
			throwException(ErrorEnum.USER_ACCOUNT_DEACTIVE_113);
		}
		if (userProfile.getDeactivationReason() != null ) {
			throwException(ErrorEnum.USER_ACCOUNT_DEACTIVE_113);
		}
		if (userProfile.getLockDate() != null) {
			throwException(ErrorEnum.INELIGIBLE_USER_REASON_BLOCKED_106);
		}
		//TODO: need to be implemented
//		if (!hasTermsBeenAccepted(userProfile)) {
//			throw new MHVException(ErrorEnum.USER_MHV_TC_STALE__114);
//		}
		if (userProfile.getDeactivationReason() != null ) {
			throwException(ErrorEnum.USER_ACCOUNT_DEACTIVE_113);
		}

	}
	
	public static void throwException(ErrorEnum errorEnum) throws WebApplicationException {
		ResponseBuilderImpl builder = new ResponseBuilderImpl();
		builder.status(400);

		ErrorTO error = new ErrorTO(errorEnum);
		CacheHandler.getInstance().setError(error);

		Response responseException = builder.build();
		throw new WebApplicationException(responseException);
	}

	/*
	public static void throwExceptionOnErrors(ErrorEnum errorEnum, MHVException mhvException) throws WebApplicationException {
	
		if( mhvException.getErrorMessages().size()  > 0 ) {
			ResponseBuilderImpl builder = new ResponseBuilderImpl();
			builder.status(400);

			ErrorTO error = new ErrorTO(errorEnum);
			StringBuffer sb = new StringBuffer();
			Collection<Message> msgs = (Collection<Message>)mhvException.getErrorMessages();
			for(Message message: msgs) {
				sb.append(message.getSeverity()+":"+message.getKey()+";");
			}
			error.setDeveloperMessage(sb.toString());
			CacheHandler.getInstance().setError(error);

			Response responseException = builder.build();
			throw new WebApplicationException(responseException);
		}
	}
	*/
	
	public static void throwExceptionOnErrors(ErrorEnum errorEnum, MHVException mhvException) throws WebApplicationException {
	
	ResponseBuilderImpl builder = new ResponseBuilderImpl();
	builder.status(400);

	ErrorTO error = new ErrorTO(errorEnum);
	StringBuffer sb = new StringBuffer();
	sb.append("Error:"+mhvException.getFailureMessage()+";");
	error.setDeveloperMessage(sb.toString());
	CacheHandler.getInstance().setError(error);

	Response responseException = builder.build();
	throw new WebApplicationException(responseException);
	}	

	public static void throwExceptionOnErrors(ErrorEnum errorEnum, ResponseUtil responseUtil ) throws WebApplicationException {
		if(responseUtil.getFailureMessage() != null && !responseUtil.getFailureMessage().isEmpty()) {
			log.error("Error in ResponseUtil: " + responseUtil.getFailureMessage());
			ResponseBuilderImpl builder = new ResponseBuilderImpl();
			builder.status(400);
		
			ErrorTO error = new ErrorTO(errorEnum);
			StringBuffer sb = new StringBuffer();
			sb.append("Error:"+responseUtil.getFailureMessage()+";");
			error.setDeveloperMessage(sb.toString());
			CacheHandler.getInstance().setError(error);
		
			Response responseException = builder.build();
			throw new WebApplicationException(responseException);
		}
	}	
	/*
	public static void throwExceptionOnErrorsRx(ErrorEnum errorEnum, ResponseUtil responseUtil ) throws WebApplicationException {
		LinkedHashMap<String, String> messageList = responseUtil.getInfoMessages();
		if (!messageList.isEmpty()) {
			for(String key : messageList.keySet()) {
				 String message = messageList.get(key);
				 if(key.contains("error")) {
						ResponseBuilderImpl builder = new ResponseBuilderImpl();
						builder.status(400);
						ErrorTO error = new ErrorTO(errorEnum);
						StringBuffer sb = new StringBuffer();
						sb.append("Error:"+responseUtil.getInfoMessages()+";");
						error.setDeveloperMessage(sb.toString());
						CacheHandler.getInstance().setError(error);
					
						Response responseException = builder.build();
						throw new WebApplicationException(responseException);
					}
				 }
			}
		        
		
		if(responseUtil.getFailureMessage() != null && !responseUtil.getFailureMessage().isEmpty()) {
			log.error("Error in ResponseUtil: " + responseUtil.getFailureMessage());
			ResponseBuilderImpl builder = new ResponseBuilderImpl();
			builder.status(400);
		
			ErrorTO error = new ErrorTO(errorEnum);
			StringBuffer sb = new StringBuffer();
			sb.append("Error:"+responseUtil.getFailureMessage()+";");
			error.setDeveloperMessage(sb.toString());
			CacheHandler.getInstance().setError(error);
		
			Response responseException = builder.build();
			throw new WebApplicationException(responseException);
		}
	}	
	*/
	public static String makeActivityDetailValue(String detailValue) {
		 return "Remote System: "+detailValue;
	}
	
}
